/*
 * Decompiled with CFR 0.152.
 */
package dev.cxd.raven_delivery.entity;

import dev.cxd.raven_delivery.entity.RavenVariant;
import dev.cxd.raven_delivery.entity.goals.FlyTreeGoal;
import dev.cxd.raven_delivery.entity.goals.RavenDeliverBundleGoal;
import dev.cxd.raven_delivery.init.ModEntities;
import dev.cxd.raven_delivery.init.ModSounds;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1331;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1348;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class RavenEntity
extends class_1321
implements class_5354 {
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    public class_7094 sittingAnimationState = new class_7094();
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(RavenEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> RECEIVER_UUID = class_2945.method_12791(RavenEntity.class, (class_2941)class_2943.field_13313);
    public static final class_2940<Boolean> GOING_TO_RECEIVER = class_2945.method_12791(RavenEntity.class, (class_2941)class_2943.field_13323);
    private class_1799 carriedBundle = class_1799.field_8037;
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(RavenEntity.class, (class_2941)class_2943.field_13327);

    public RavenEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 10, false);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(0, new RavenDeliverBundleGoal<RavenEntity>(this, 1.0, 6.0f, 128.0f, false));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.25, (Predicate)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8317}), false));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 1.0, 5.0f, 1.0f));
        this.field_6201.method_6277(4, (class_1352)new FlyTreeGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1359((class_1308)this, 0.4f));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(6, (class_1352)new class_1348((class_1308)this, 1.0, 3.0f, 7.0f));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1321.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23717, 32.0);
    }

    private void setupAnimationStates() {
        if (this.method_24345()) {
            this.sittingAnimationState.method_41324(this.field_6012);
        } else {
            this.sittingAnimationState.method_41325();
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 120;
                this.idleAnimationState.method_41322(this.field_6012);
            } else {
                --this.idleAnimationTimeout;
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!this.method_6181() && stack.method_31573(class_3489.field_49932)) {
            this.method_6475(player, hand, stack);
            if (!this.method_37908().field_9236) {
                if (this.field_5974.method_43048(5) == 0) {
                    this.method_6170(player);
                    this.method_24346(true);
                    this.method_37908().method_8421((class_1297)this, (byte)7);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)6);
                }
            }
            return class_1269.field_5812;
        }
        if (stack.method_31574(class_1802.field_27023) && !stack.method_7964().getString().isEmpty() && this.method_6181() && this.method_6171((class_1309)player)) {
            String targetName = stack.method_7964().getString();
            MinecraftServer server = this.method_5682();
            if (server != null) {
                class_3222 target = server.method_3760().method_14571().stream().filter(p -> p.method_5477().getString().equalsIgnoreCase(targetName)).findFirst().orElse(null);
                if (target != null) {
                    this.setReceiverUuid(target.method_5667());
                    this.setCarriedBundle(stack.method_7972());
                    stack.method_7934(1);
                    this.method_24346(false);
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)("No player named \"" + targetName + "\" is online.")), true);
                return class_1269.field_5814;
            }
        }
        if (this.method_6181() && this.method_6171((class_1309)player)) {
            if (!this.method_37908().field_9236) {
                this.method_24346(!this.method_24345());
                this.field_6189.method_6340();
                this.method_5980(null);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void setCarriedBundle(class_1799 stack) {
        this.carriedBundle = stack;
    }

    public class_1799 getCarriedBundle() {
        return this.carriedBundle;
    }

    public boolean hasCarriedBundle() {
        return !this.carriedBundle.method_7960();
    }

    public void setReceiverUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(RECEIVER_UUID, Optional.ofNullable(uuid));
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world);
        birdNavigation.method_6354(true);
        return birdNavigation;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
    }

    public void method_6007() {
        this.flapWings();
        super.method_6007();
    }

    private void flapWings() {
        class_243 vec3d = this.method_18798();
        if (!this.method_24828() && vec3d.field_1351 < 0.0) {
            this.method_18799(vec3d.method_18805(1.0, 0.6, 1.0));
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8317);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        RavenEntity baby = (RavenEntity)ModEntities.RAVEN.method_5883((class_1937)world);
        assert (baby != null);
        if (entity instanceof RavenEntity) {
            RavenEntity other = (RavenEntity)entity;
            RavenVariant[] parentVariants = new RavenVariant[]{this.getVariant(), other.getVariant()};
            RavenVariant variant = (RavenVariant)((Object)class_156.method_32309(Arrays.asList(parentVariants), (class_5819)this.field_5974));
            baby.setVariant(variant);
            if (this.method_6181() && other.method_6181()) {
                baby.method_6173(true, true);
                baby.method_6170((class_1657)this.method_35057());
            }
        }
        return baby;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RECEIVER_UUID, Optional.empty());
        builder.method_56912(GOING_TO_RECEIVER, (Object)false);
        builder.method_56912(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.method_56912(SITTING, (Object)false);
    }

    public boolean method_24345() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void method_24346(boolean sitting) {
        this.field_6011.method_12778(SITTING, (Object)sitting);
    }

    public UUID getReceiverUuid() {
        return ((Optional)this.field_6011.method_12789(RECEIVER_UUID)).orElse(null);
    }

    public RavenVariant getVariant() {
        return RavenVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(RavenVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Sitting", this.method_24345());
        nbt.method_10569("Variant", this.getTypeVariant());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_24346(nbt.method_10577("Sitting"));
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_10550("Variant"));
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        RavenVariant variant = (RavenVariant)((Object)class_156.method_27173((Object[])RavenVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected class_3414 method_5994() {
        return ModSounds.RAVEN_CAW;
    }

    public int method_29507() {
        return 0;
    }

    public void method_29514(int angerTime) {
    }

    @Nullable
    public UUID method_29508() {
        return null;
    }

    public void method_29513(@Nullable UUID angryAt) {
    }

    public void method_29509() {
    }
}

