/*
 * Decompiled with CFR 0.152.
 */
package dev.cxd.raven_delivery.entity.goals;

import dev.cxd.raven_delivery.entity.RavenEntity;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7;

public class RavenDeliverBundleGoal<T extends class_1321>
extends class_1352 {
    private final T tameable;
    private class_1309 owner;
    private final class_1937 world;
    private final double speed;
    private final class_1408 navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;
    private final boolean leavesAllowed;
    private class_1309 receiver;

    public RavenDeliverBundleGoal(T tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
        this.tameable = tameable;
        this.world = tameable.method_37908();
        this.speed = speed;
        this.navigation = tameable.method_5942();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.leavesAllowed = leavesAllowed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(tameable.method_5942() instanceof class_1407) && !(tameable.method_5942() instanceof class_1408) || !(tameable instanceof RavenEntity)) {
            throw new IllegalArgumentException("Unsupported mob type for DeliverBundleGoal");
        }
    }

    public boolean method_6264() {
        RavenEntity raven = (RavenEntity)((Object)this.tameable);
        UUID receiverUuid = raven.getReceiverUuid();
        if (receiverUuid == null) {
            return false;
        }
        class_1297 potentialReceiver = ((class_3218)this.world).method_14190(receiverUuid);
        if (!(potentialReceiver instanceof class_1309)) {
            return false;
        }
        this.receiver = (class_1309)potentialReceiver;
        class_1309 ownerCandidate = this.tameable.method_35057();
        if (ownerCandidate == null || !ownerCandidate.method_5805()) {
            return false;
        }
        if (this.tameable.method_5858((class_1297)this.receiver) < (double)(this.minDistance * this.minDistance) && raven.hasCarriedBundle()) {
            class_1799 bundle = raven.getCarriedBundle().method_7972();
            class_1542 drop = new class_1542(this.world, this.receiver.method_23317(), this.receiver.method_23318() + 1.0, this.receiver.method_23321(), bundle);
            drop.method_18800(0.0, 0.25, 0.0);
            this.world.method_8649((class_1297)drop);
            raven.setCarriedBundle(class_1799.field_8037);
            raven.setReceiverUuid(null);
            raven.method_5841().method_12778(RavenEntity.GOING_TO_RECEIVER, (Object)false);
            return false;
        }
        this.owner = ownerCandidate;
        return true;
    }

    public boolean method_6266() {
        if (this.navigation.method_6357()) {
            return false;
        }
        return this.tameable.method_5858((class_1297)this.receiver) > (double)(this.maxDistance * this.maxDistance);
    }

    public void method_6269() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.tameable.method_5944(class_7.field_18);
        this.tameable.method_5941(class_7.field_18, 0.0f);
        this.tameable.method_5841().method_12778(RavenEntity.GOING_TO_RECEIVER, (Object)true);
    }

    public void method_6270() {
        this.receiver = null;
        this.navigation.method_6340();
        this.tameable.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
    }

    public void method_6268() {
        this.tameable.method_5988().method_6226((class_1297)this.receiver, 10.0f, (float)this.tameable.method_5978());
        if (this.tameable.method_5858((class_1297)this.receiver) < 4.0 && ((RavenEntity)((Object)this.tameable)).hasCarriedBundle()) {
            class_1799 bundle = ((RavenEntity)((Object)this.tameable)).getCarriedBundle().method_7972();
            class_1542 drop = new class_1542(this.world, this.receiver.method_23317(), this.receiver.method_23318() + 1.0, this.receiver.method_23321(), bundle);
            drop.method_18800(0.0, 0.25, 0.0);
            this.world.method_8649((class_1297)drop);
            ((RavenEntity)((Object)this.tameable)).setCarriedBundle(class_1799.field_8037);
            ((RavenEntity)((Object)this.tameable)).setReceiverUuid(null);
            this.tameable.method_5841().method_12778(RavenEntity.GOING_TO_RECEIVER, (Object)false);
            this.navigation.method_6340();
            this.method_6270();
            return;
        }
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = 10;
            if (this.tameable.method_5858((class_1297)this.receiver) >= 10000.0) {
                this.tryTeleport();
            } else {
                this.navigation.method_6335((class_1297)this.receiver, this.speed);
            }
        }
    }

    private void tryTeleport() {
        class_2338 targetPos = this.receiver.method_24515();
        for (int i = 0; i < 10; ++i) {
            int dx = this.getRandomInt(-3, 3);
            int dy = this.getRandomInt(-1, 1);
            int dz = this.getRandomInt(-3, 3);
            boolean success = this.tryTeleportTo(targetPos.method_10263() + dx, targetPos.method_10264() + dy, targetPos.method_10260() + dz);
            if (!success) continue;
            return;
        }
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.receiver.method_23317()) < 2.0 && Math.abs((double)z - this.receiver.method_23321()) < 2.0) {
            return false;
        }
        class_2338 targetPos = new class_2338(x, y, z);
        if (!this.canTeleportTo(targetPos)) {
            return false;
        }
        this.tameable.method_5808((double)x + 0.5, (double)y, (double)z + 0.5, this.tameable.method_36454(), this.tameable.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos) {
        class_2680 blockState = this.world.method_8320(pos.method_10074());
        if (!this.leavesAllowed && blockState.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 offset = pos.method_10059((class_2382)this.tameable.method_24515());
        return this.world.method_8587(this.tameable, this.tameable.method_5829().method_996(offset));
    }

    private int getRandomInt(int min, int max) {
        return this.tameable.method_59922().method_43048(max - min + 1) + min;
    }
}

